﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodClassIndex : BaseAPIMethod
        {

            public MethodClassIndex(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "classindex"; }
            }

            private int _schoolId = 0;
            private int _instructorId = 0;

            protected override void DoReadRequestParams()
            {
                string _school_id = Component.APIRequestParams["school_id"];
                if (!string.IsNullOrEmpty(_school_id))
                {
                    int.TryParse(_school_id, out _schoolId);
                }

                string _instructor_id = Component.APIRequestParams["instructor_id"];
                if (!string.IsNullOrEmpty(_instructor_id))
                {
                    int.TryParse(_instructor_id, out _instructorId);
                }
            }

            /// <summary>
            /// Tutaj musimy nadpisac walidacje bazowa, bo nie ma sesji
            /// wiec sprawdzamy tylko czy sa parametry w URLu wlasciwe
            /// </summary>
            /// <returns></returns>
            protected override bool IsValid()
            {
                return DoValidate();
            }
            
            protected override bool DoValidate()
            {
                if (_schoolId > 0)
                {
                    return true;
                }
                AddErrorMessage("Podano nieprawidłowy identyfikator szkoły.");
                return false;
            }

            protected override GResponseData DoGetGResponseData()
            {
                if (Component.BLELearning.APIMobile.SchoolExists(_schoolId))
                {
                    List<GClassIndex> _listGClassIndex = Component.BLELearning.APIMobile.GetGClassIndexList(_schoolId, _instructorId);
                    if (_listGClassIndex != null && _listGClassIndex.Count > 0)
                    {
                        StatusCode = StatusCodeType.OK;
                        return new GResponseData_ClassIndex() { Class = _listGClassIndex, count = _listGClassIndex.Count };
                    }
                    AddErrorMessage("Dla podanej szkoły nie znaleziono klas.");
                }
                else
                {
                    AddErrorMessage("Nie istnieje szkoła o podanym identyfikatorze.");
                }
                StatusCode = StatusCodeType.NotFound;
                return null;
            }
        }
    }
}